C********************************************************************


      SUBROUTINE USRMTR(NPTRTN,YS,YPS,FIP,TEPS,EFEPS,TEMP)
C********************************************************************
C
C     THIS SUBROUTINE CALCULATES THE FLOW STRESS OF PLASTIC MATERIAL
C
C     INPUT :
C
C      NPTRTN    =   FLOW STRESS NUMBER
C      TEPS      =   EFFECTIVE STRAIN
C      EFEPS     =   EFFECTIVE STRAIN RATE
C      TEMP      =   TEMPERATURE
C
C     OUTPUT :
C
C      YS        =   FLOW STRESS
C      YPS       =   DERIVATIVE OF FLOW STRESS W.R.T TEPS
C      FIP       =   DERIVATIVE OF FLOW STRESS W.R.T. EFEPS
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C  USER SUPPLIED SUBROUTINES
C
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     Version 5.1
C
C     COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(4),EPSE(4),EFEPSE,EFSTSE,

C    +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),USRE1(2),USRE2(2),
C    +                NODEE(4),KELE
C
C     Version 6.0
C
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable at the begining of step 
C         USRE2   : Element user variable at the end of the step 
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C
      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP


C
C     COMMON /NODCOM/
C
C        RZN      : Nodal point coordinates
C        URZN     : Nodal point velocities
C        DRZN     : Nodal point displacement
C        TEMPN    : Nodal point temperature
C        USRN1    : User defined state variables (Input : At the beginning of Step N)
C        USRN2    : User defined state variables (Output: At the end of Step N)
C        KNODE    : Node number
C
      COMMON /NODCOM/ RZN(2),URZN(2),DRZN(2),TEMPN,DTMPN,USRN1(1500),
     +                USRN2(1500),KNODE

C
C     CURTIM: CURRENT TIME           
C      
      COMMON /CLOK/ CURTIM
C
C     DTMAXC: CURRENT TIME STEP SIZE
C
      COMMON /SSTU/ DTMAXC
C
C
C     COMMON /USRCTL/
C
C        KOBJ      : Object number
C        KSTEP     : Step number (N)
C        ISTATUS   : 0 - the beginning of the step
C                    1 - the end of the step
C        KSSTEP    : negative step indication -1 for negative step 1 for else
C
C     WHEN (ISTATUS.EQ. 1)  --> USRE2/USRN2 should be updated here
C     KELE  > 0             --> Element data is active
C     INODE > 0             --> Node Data is active
C
      COMMON /USRCTL/ KOBJ,ISTATUS,KSTEP,KSSTEP
C
C
C     Branching to proper flow stress routine based on the
C     number specified in the pre-processor
C     
C
      GO TO (510,520,530,540,550,560,570,580,590,600),NPTRTN 
C     
  510 CALL UFLOW1(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  520 CALL UFLOW2(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  530 CALL UFLOW3(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  540 CALL UFLOW4(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  550 CALL UFLOW5(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  560 CALL UFLOW6(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  570 CALL UFLOW7(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  580 CALL UFLOW8(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  590 CALL UFLOW9(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  600 CALL UFLOW10(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
C  TO BE CONTINUED BY USER
C
      END
C********************************************************************

      SUBROUTINE UFLOW1(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C
C********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N) 

C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     DESCRIPTION
C
C       THIS ROUTINE IS USED TO DEMONSTRATE THE IMPLEMENTATION OF
C       MATERIAL ROUTINE.  ALL THE REAL VARIABLES SHOULD BE DOUBLE 
C       PRECISION. THE DEFINITION OF ARGUMENTS ARE DESCRIBED AS FOLLOWS:
C
C    INPUT :
C
C      TEPS     =   EFFECTIVE STRAIN
C      EFEPS    =   EFFECTIVE STRAIN RATE
C      TEMP     =   TEMPERATURE
C
C    OUTPUT :
C
C      YS       =   FLOW STRESS
C      YPS      =   DERIVATIVE OF FLOW STRESS W.R.T. TEPS
C      FIP      =   DERIVATIVE OF FLOW STRESS W.R.T. EFEPS
C
C
      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP

C
C    EXAMPLE :
C    
C       PEM = STRAIN_RATE SENSITIVITY INDEX
C       YS = MATERIAL_CONSTANT * (STRAIN)**PEN* (STRAIN_RATE)**PEM
C       PEN = STRAIN SENSITIVITY INDEX
C       FIP = MATERIAL_CONSTANT * PEM * (STRAIN_RATE)**(PEM-1.)
C       YPS = 0.
C
C   STRAIN CAN COME FROM ONE OF THE THREE SOURCES
C
C     (1) FROM THE INPUT ARGUMENT "TEPS"
C     (2) FROM THE ELEMENT COMMON BLOCK "TEPSE"
C     (3) FROM THE USER DEFINED STATE VARIABLES (SEE THE ROUTINE "USRST1")
C
C     THE FOLLOWING EXAMPLE IS WRITTEN BASED ON THE USED DEFINED STATE 
C     VARIABLE
C
      STRAIN = USRE1(1)
      IF (STRAIN.LE.0.) STRAIN = 1.E-5
C      IF (EFEPS.LE.0.0) EFEPS=1.E-5
      EFEPS=EFEPSE
C
      PEN = 0.15
      PEM = 0.1
      YS0= 1.0
C
      YS = 10. * STRAIN**PEN* (EFEPS)**PEM+YS0
      FIP = 10. * STRAIN**PEN* PEM * (EFEPS)**(PEM-1.)
      YPS = 10. * PEN * STRAIN**(PEN-1.) * ((EFEPS)**(PEM-1))
      IF(STRAIN.EQ.1.E-5) YPS=0.0
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW2(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), DOUBLEPRECISION (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION 
C            
C   HENSEL - SPITTEL EQUATION
C  YS = A*(EXP(M1*TEMP))*(TEPS**M2)*(EFEPS**M3)*(EXP(M4/TEPS))
            READ(IUSRVL(1),*) A, M1, M2, M3, M4
             IF (TEPS.LE.2.E-3) TEPS=2.E-3
             IF (EFEPS.LE.2.E-3) EFEPS=2.E-3
             YS = A*(EXP(M1*TEMP))*(TEPS**M2)*(EFEPS**M3)*(EXP(M4/TEPS))
             YPS= A*(EXP(M1*TEMP))*(EFEPS**M3) 
     &     *(((-M4*TEPS**(M2-2))* (EXP(M4/TEPS)))+ 
     &      ((M2*(EXP(M4/TEPS))*TEPS**(M2-1))))
             FIP = A*EXP(M1*TEMP)*(TEPS**M2)*EXP(M4/TEPS)*M3
     &     * (EFEPS**(M3-1))    
            RETURN
            END
C********************************************************************

      SUBROUTINE UFLOW3(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW4(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW5(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW6(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW7(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW8(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW9(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW10(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************
